/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css;

import com.aptana.css.core.CSSColors;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class CSSColorsUI {
    private static final String HASH = "#";

    public static RGB hexToRGB(String color) {
        return CSSColorsUI.toRGB(CSSColors.to6CharHexWithLeadingHash((String)color));
    }

    public static RGB namedColorToRGB(String name) {
        return CSSColorsUI.toRGB(CSSColors.getHexValueForName((String)name));
    }

    private static RGB toRGB(String color) {
        if (CSSColors.namedColorExists((String)color.toLowerCase())) {
            color = CSSColors.getHexValueForName((String)color.toLowerCase());
        }
        if (color.startsWith(HASH)) {
            color = color.substring(1);
        }
        if (color.length() == 3) {
            int red = Integer.decode(HASH + color.substring(0, 1) + color.substring(0, 1));
            int green = Integer.decode(HASH + color.substring(1, 2) + color.substring(1, 2));
            int blue = Integer.decode(HASH + color.substring(2, 3) + color.substring(2, 3));
            return new RGB(red, green, blue);
        }
        int red = Integer.decode(HASH + color.substring(0, 2));
        int green = Integer.decode(HASH + color.substring(2, 4));
        int blue = Integer.decode(HASH + color.substring(4, 6));
        return new RGB(red, green, blue);
    }

    public static Image toImage(String color, int height, int width) {
        RGB actualColor = CSSColorsUI.toRGB(color);
        PaletteData paletteData = new PaletteData(new RGB[]{actualColor, new RGB(0, 0, 0)});
        ImageData imageData = new ImageData(16, 16, 1, paletteData);
        return new Image((Device)Display.getDefault(), imageData);
    }
}

